/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class MediaServicesUtil
implements MediaServicesErrorIds {
    private static final String TRACE_MASKT = "XMDAUTLT";
    private static final String TRACE_MASKF = "XMDAUTLF";
    private static final String TRACE_MASKD = "XMDAUTLD";
    private static FrameworkClassLogInfo LOGINFO = new FrameworkClassLogInfo(85, "MediaSvcUtil");
    private static final String MEDIA_SERVICES_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private PanelTasklet panelTasklet;
    private PanelTasklet busyPanelTasklet;
    private MediaServices mediaServices;
    private MediaDevice mediaDevice;
    private MediaDeviceIdentifier mediaDeviceIdentifier;
    private boolean busyDisplayed = false;
    public static final int MEDIA_DISKETTE = 1;
    public static final int MEDIA_CDROM = 2;
    public static final int MEDIA_DVDRAM = 3;
    public static final int MEDIA_HDPARTITION = 4;
    public static final int MEDIA_WRITABLE_MASS = 6;
    public static final int MEDIA_READONLY_MASS = 7;
    private LocalizableText title;
    private MessageText message;
    private LocalizableText answer;
    private static final String MEDIA_SERVICES_ERROR_TITLE = "MDA.MEDIA.SERVICES.ERROR.TITLE";
    private static final String MEDIA_SERVICES_ERROR_TEXT = "MDA.MEDIA.SERVICES.ERROR.TEXT";
    private static final String MEDIA_DEVICE_ERROR_TITLE = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TITLE";
    private static final String MEDIA_DEVICE_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT";
    private static final String MEDIA_DEVICE_LOCKED_ERROR_TITLE = "MDA.MEDIA.SERVICES.DEVICE.LOCKED.ERROR.TITLE";
    private static final String MEDIA_DEVICE_LOCKED_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.LOCKED.ERROR.TEXT";
    private static final String MEDIA_DEVICE_UNLOCK_ERROR_TITLE = "MDA.MEDIA.SERVICES.UNLOCK.MEDIA.ERROR.TITLE";
    private static final String MEDIA_DEVICE_UNLOCK_ERROR_TEXT = "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT";
    private static final String MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE = "MDA.MEDIA.SERVICES.NO.MEDIA.PRESENT.ERROR.TITLE";
    private static final String MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT = "MDA.MEDIA.SERVICES.NO.MEDIA.PRESENT.ERROR.TEXT";
    private static final String MEDIA_MISSING_LABEL_ERROR_TITLE = "MDA.MEDIA.SERVICES.MEDIA.MISSING.LABEL.ERROR.TITLE";
    private static final String MEDIA_MISSING_LABEL_ERROR_TEXT = "MDA.MEDIA.SERVICES.MEDIA.MISSING.LABEL.ERROR.TEXT";
    private static final String MEDIA_INCORRECT_LABEL_ERROR_TITLE = "MDA.MEDIA.SERVICES.INCORRECT.MEDIA.LABEL.ERROR.TITLE";
    private static final String MEDIA_INCORRECT_LABEL_ERROR_TEXT = "MDA.MEDIA.SERVICES.INCORRECT.MEDIA.LABEL.ERROR.TEXT";
    private static final String MEDIA_WRITE_PROTECTED_ERROR_TITLE = "MDA.MEDIA.SERVICES.MEDIA.WRITE.PROTECTED.ERROR.TITLE";
    private static final String MEDIA_WRITE_PROTECTED_ERROR_TEXT = "MDA.MEDIA.SERVICES.MEDIA.WRITE.PROTECTED.ERROR.TEXT";
    private static final String MEDIA_INVALID_FILESYSTEM_ERROR_TITLE = "MDA.MEDIA.SERVICES.INVALID.FILESYSTEM.ERROR.TITLE";
    private static final String MEDIA_INVALID_FILESYSTEM_ERROR_TEXT = "MDA.MEDIA.SERVICES.INVALID.FILESYSTEM.ERROR.TEXT";
    private static final String MEDIA_SERVICES_BUSY_TITLE = "MDA.MEDIA.SERVICES.BUSY.TITLE";
    private static final String MEDIA_SERVICES_BUSY_TEXT = "MDA.MEDIA.SERVICES.BUSY.TEXT";

    public MediaServicesUtil(PanelTasklet panel) {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.MediaServicesUtil(panel = " + panel + ")");
        this.panelTasklet = panel;
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.MediaServicesUtil()");
    }

    public void setPanelTasklet(PanelTasklet panel) {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.setPanelTasklet()");
        this.panelTasklet = panel;
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.setPanelTasklet()");
    }

    public boolean isMessageBoxEnabled() {
        Trace.trace(TRACE_MASKT, "<> MediaServicesUtil.isMessageBoxEnabled()");
        return this.panelTasklet != null;
    }

    public MediaDevice getMediaDevice() throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.getMediaDevice()");
        if (this.mediaDevice == null) {
            throw new MediaServicesUtilException("Media device has not been prepared", 2, this.isMessageBoxEnabled());
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.getMediaDevice()");
        return this.mediaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDeviceIdentifier queryMediaDevicePath(String filepath) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.queryMediaDevicePath(filepath = " + filepath + ")");
        try {
            this.showMediaServicesBusyDialog();
            try {
                this.mediaServices = MediaServices.getMediaServices();
                this.mediaDeviceIdentifier = this.mediaServices.queryMediaDevicePath(filepath);
            }
            catch (MediaDeviceException mediaDeviceException) {
                Trace.trace(TRACE_MASKF, "MediaServicesUtil.queryMediaDevicePath(): " + mediaDeviceException);
                Trace.trace(TRACE_MASKF, mediaDeviceException);
                if (this.panelTasklet != null) {
                    this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TITLE);
                    this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TEXT);
                    this.displayMediaMessageBox(this.title, this.message);
                }
                throw new MediaServicesUtilException(mediaDeviceException, 0, this.isMessageBoxEnabled());
            }
            Object var4_3 = null;
            this.destoryMediaServicesBusyDialog();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.destoryMediaServicesBusyDialog();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.queryMediaDevicePath()");
        return this.mediaDeviceIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDevice prepareMedia(int mediaType, LocalizableText callerName) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.prepareMedia(mediaType = " + mediaType + ", " + "callerName = " + callerName.toString() + ")");
        try {
            if (this.mediaDevice != null) {
                throw new MediaServicesUtilException("The Media Device is not released.", 5, this.isMessageBoxEnabled());
            }
            this.showMediaServicesBusyDialog();
            boolean isSuccessful = false;
            while (!isSuccessful) {
                try {
                    this.mediaServices = MediaServices.getMediaServices();
                    this.mediaDeviceIdentifier = this.mediaServices.getPreferredDevice(mediaType);
                    try {
                        this.mediaDevice = this.mediaServices.requestLock(callerName, this.mediaDeviceIdentifier);
                        isSuccessful = true;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                        if (this.panelTasklet != null) {
                            this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                            this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT, new String[]{this.mediaDeviceIdentifier.getCurrentLockOwner().toString()});
                            this.answer = this.displayMediaMessageBox(this.title, this.message);
                            if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                            throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                        }
                        throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                    }
                    catch (MediaDeviceException mediaDeviceException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                        Trace.trace(TRACE_MASKF, mediaDeviceException);
                        this.mediaDevice = null;
                        if (this.panelTasklet != null) {
                            this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_ERROR_TITLE);
                            this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT");
                            this.answer = this.displayMediaMessageBox(this.title, this.message);
                        }
                        throw new MediaServicesUtilException(mediaDeviceException, 3, this.isMessageBoxEnabled());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + illegalArgumentException);
                    Trace.trace(TRACE_MASKF, illegalArgumentException);
                    this.mediaDevice = null;
                    throw new MediaServicesUtilException(illegalArgumentException, 1, this.isMessageBoxEnabled());
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                    Trace.trace(TRACE_MASKF, mediaDeviceException);
                    this.mediaDevice = null;
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TEXT);
                        this.displayMediaMessageBox(this.title, this.message);
                    }
                    throw new MediaServicesUtilException(mediaDeviceException, 0, this.isMessageBoxEnabled());
                }
            }
            Object var7_8 = null;
            this.destoryMediaServicesBusyDialog();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.destoryMediaServicesBusyDialog();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.prepareMedia()");
        return this.mediaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDevice prepareMedia(MediaDeviceIdentifier mediaDeviceId, LocalizableText callerName) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.prepareMedia(mediaDeviceId = " + mediaDeviceId + ", " + "callerName = " + callerName.toString() + ")");
        try {
            if (this.mediaDevice != null) {
                throw new MediaServicesUtilException("The Media Device is not released.", 5, this.isMessageBoxEnabled());
            }
            this.showMediaServicesBusyDialog();
            boolean isSuccessful = false;
            while (!isSuccessful) {
                try {
                    this.mediaServices = MediaServices.getMediaServices();
                    this.mediaDeviceIdentifier = mediaDeviceId;
                    try {
                        this.mediaDevice = this.mediaServices.requestLock(callerName, this.mediaDeviceIdentifier);
                        isSuccessful = true;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                        if (this.panelTasklet != null) {
                            this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                            this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT, new String[]{this.mediaDeviceIdentifier.getCurrentLockOwner().toString()});
                            this.answer = this.displayMediaMessageBox(this.title, this.message);
                            if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                            throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                        }
                        throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                    }
                    catch (MediaDeviceException mediaDeviceException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                        Trace.trace(TRACE_MASKF, mediaDeviceException);
                        this.mediaDevice = null;
                        if (this.panelTasklet != null) {
                            this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_ERROR_TITLE);
                            this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT");
                            this.answer = this.displayMediaMessageBox(this.title, this.message);
                        }
                        throw new MediaServicesUtilException(mediaDeviceException, 3, this.isMessageBoxEnabled());
                    }
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                    Trace.trace(TRACE_MASKF, mediaDeviceException);
                    this.mediaDevice = null;
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_ERROR_TEXT);
                        this.displayMediaMessageBox(this.title, this.message);
                    }
                    throw new MediaServicesUtilException(mediaDeviceException, 0, this.isMessageBoxEnabled());
                }
            }
            Object var7_7 = null;
            this.destoryMediaServicesBusyDialog();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.destoryMediaServicesBusyDialog();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.prepareMedia()");
        return this.mediaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDevice prepareMedia(int mediaType, LocalizableText callerName, boolean mountReadWrite, String label) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.prepareMedia(mediaType = " + mediaType + ", " + "callerName = " + callerName.toString() + ", " + "mountReadWrite = " + mountReadWrite + ", " + "label = " + label + ")");
        try {
            if (this.mediaDevice != null) {
                throw new MediaServicesUtilException("The Media Device is not released.", 5, this.isMessageBoxEnabled());
            }
            boolean isSuccessful = false;
            while (!isSuccessful) {
                try {
                    this.mediaDevice = this.prepareMedia(mediaType, callerName);
                    if (mediaType == 2 || mediaType == 7) {
                        this.mediaDevice.mountReadOnly();
                    } else if (mountReadWrite) {
                        this.mediaDevice.mountReadWrite();
                    } else {
                        this.mediaDevice.mountReadOnly();
                    }
                    if (label != null) {
                        block45: {
                            try {
                                int fsType = this.mediaDevice.getFileSystemType();
                                if (mediaType == 4 && fsType == 1 || (mediaType == 2 || mediaType == 3 || mediaType == 7 || mediaType == 6) && fsType != 2 && fsType != 3) {
                                    label = null;
                                }
                            }
                            catch (MediaDeviceException mediaDeviceException) {
                                Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                                Trace.trace(TRACE_MASKF, mediaDeviceException);
                                if (!mediaDeviceException.getMessage().equals("unknown file system")) break block45;
                                label = null;
                            }
                        }
                        if (label != null) {
                            try {
                                String mediaLabel = this.mediaDevice.getLabel();
                                if (mediaLabel == null) {
                                    this.mediaDevice.unlock();
                                    this.mediaDevice = null;
                                    if (this.panelTasklet != null) {
                                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_MISSING_LABEL_ERROR_TITLE);
                                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_MISSING_LABEL_ERROR_TEXT);
                                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                        throw new MediaServicesUtilException("The media does not have a label", 11, this.isMessageBoxEnabled());
                                    }
                                    throw new MediaServicesUtilException("The media does not have a label", 6, this.isMessageBoxEnabled());
                                }
                                if (!label.equals(mediaLabel)) {
                                    this.mediaDevice.unlock();
                                    this.mediaDevice = null;
                                    if (this.panelTasklet != null) {
                                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INCORRECT_LABEL_ERROR_TITLE);
                                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INCORRECT_LABEL_ERROR_TEXT);
                                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                        throw new MediaServicesUtilException("The label on the media is incorrect.", 11, this.isMessageBoxEnabled());
                                    }
                                    throw new MediaServicesUtilException("The label on the media is incorrect.", 7, this.isMessageBoxEnabled());
                                }
                                isSuccessful = true;
                                continue;
                            }
                            catch (MediaDeviceLockException mediaDeviceLockException) {
                                Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                                Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                                try {
                                    this.mediaDevice.unlock();
                                    this.mediaDevice = null;
                                }
                                catch (MediaDeviceLockException mdlexc) {
                                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mdlexc);
                                    Trace.trace(TRACE_MASKF, mdlexc);
                                    this.mediaDevice = null;
                                }
                                if (this.panelTasklet != null) {
                                    this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                                    this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT, new String[]{this.mediaDeviceIdentifier.getCurrentLockOwner().toString()});
                                    this.answer = this.displayMediaMessageBox(this.title, this.message);
                                    if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                    throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                                }
                                throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                            }
                            catch (NoMediaPresentException noMediaPresentException) {
                                Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + noMediaPresentException);
                                Trace.trace(TRACE_MASKF, noMediaPresentException);
                                try {
                                    this.mediaDevice.unlock();
                                    this.mediaDevice = null;
                                }
                                catch (MediaDeviceLockException mediaDeviceLockException) {
                                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                                    Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                                    this.mediaDevice = null;
                                }
                                if (this.panelTasklet != null) {
                                    this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE);
                                    this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT);
                                    this.answer = this.displayMediaMessageBox(this.title, this.message);
                                    if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                    throw new MediaServicesUtilException(noMediaPresentException, 11, this.isMessageBoxEnabled());
                                }
                                throw new MediaServicesUtilException(noMediaPresentException, 8, this.isMessageBoxEnabled());
                            }
                        }
                        isSuccessful = true;
                        continue;
                    }
                    isSuccessful = true;
                }
                catch (MediaDeviceLockException mediaDeviceLockException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                    Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                    this.mediaDevice = null;
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT, new String[]{this.mediaDeviceIdentifier.getCurrentLockOwner().toString()});
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                }
                catch (NoMediaPresentException noMediaPresentException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + noMediaPresentException);
                    Trace.trace(TRACE_MASKF, noMediaPresentException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(noMediaPresentException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(noMediaPresentException, 8, this.isMessageBoxEnabled());
                }
                catch (MediaWriteProtectedException mediaWriteProtectedException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaWriteProtectedException);
                    Trace.trace(TRACE_MASKF, mediaWriteProtectedException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_WRITE_PROTECTED_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_WRITE_PROTECTED_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(mediaWriteProtectedException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(mediaWriteProtectedException, 9, this.isMessageBoxEnabled());
                }
                catch (InvalidFileSystemException invalidFileSystemException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + invalidFileSystemException);
                    Trace.trace(TRACE_MASKF, invalidFileSystemException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INVALID_FILESYSTEM_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INVALID_FILESYSTEM_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(invalidFileSystemException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(invalidFileSystemException, 10, this.isMessageBoxEnabled());
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                    Trace.trace(TRACE_MASKF, mediaDeviceException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT");
                        this.displayMediaMessageBox(this.title, this.message);
                    }
                    throw new MediaServicesUtilException(mediaDeviceException, 3, this.isMessageBoxEnabled());
                }
            }
            Object var13_25 = null;
            this.destoryMediaServicesBusyDialog();
        }
        catch (Throwable throwable) {
            Object var13_26 = null;
            this.destoryMediaServicesBusyDialog();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.prepareMedia()");
        return this.mediaDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaDevice prepareMedia(MediaDeviceIdentifier mediaDeviceId, LocalizableText callerName, boolean mountReadWrite, String label) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.prepareMedia(mediaDeviceId = " + mediaDeviceId + ", " + "callerName = " + callerName.toString() + ", " + "mountReadWrite = " + mountReadWrite + ", " + "label = " + label + ")");
        try {
            if (this.mediaDevice != null) {
                throw new MediaServicesUtilException("The Media Device is not released.", 5, this.isMessageBoxEnabled());
            }
            boolean isSuccessful = false;
            while (!isSuccessful) {
                try {
                    this.mediaDevice = this.prepareMedia(mediaDeviceId, callerName);
                    if (mountReadWrite) {
                        this.mediaDevice.mountReadWrite();
                    } else {
                        this.mediaDevice.mountReadOnly();
                    }
                    if (label != null) {
                        try {
                            String mediaLabel = this.mediaDevice.getLabel();
                            if (mediaLabel == null) {
                                this.mediaDevice.unlock();
                                this.mediaDevice = null;
                                if (this.panelTasklet != null) {
                                    this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_MISSING_LABEL_ERROR_TITLE);
                                    this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_MISSING_LABEL_ERROR_TEXT);
                                    this.answer = this.displayMediaMessageBox(this.title, this.message);
                                    if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                    throw new MediaServicesUtilException("The media does not have a label", 11, this.isMessageBoxEnabled());
                                }
                                throw new MediaServicesUtilException("The media does not have a label", 6, this.isMessageBoxEnabled());
                            }
                            if (!label.equals(mediaLabel)) {
                                this.mediaDevice.unlock();
                                this.mediaDevice = null;
                                if (this.panelTasklet != null) {
                                    this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INCORRECT_LABEL_ERROR_TITLE);
                                    this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INCORRECT_LABEL_ERROR_TEXT);
                                    this.answer = this.displayMediaMessageBox(this.title, this.message);
                                    if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                    throw new MediaServicesUtilException("The label on the media is incorrect.", 11, this.isMessageBoxEnabled());
                                }
                                throw new MediaServicesUtilException("The label on the media is incorrect.", 7, this.isMessageBoxEnabled());
                            }
                            isSuccessful = true;
                            continue;
                        }
                        catch (MediaDeviceLockException mediaDeviceLockException) {
                            Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                            Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                            try {
                                this.mediaDevice.unlock();
                                this.mediaDevice = null;
                            }
                            catch (MediaDeviceLockException mdlexc) {
                                Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mdlexc);
                                Trace.trace(TRACE_MASKF, mdlexc);
                                this.mediaDevice = null;
                            }
                            if (this.panelTasklet != null) {
                                this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                                this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT);
                                this.answer = this.displayMediaMessageBox(this.title, this.message);
                                if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                            }
                            throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                        }
                        catch (NoMediaPresentException noMediaPresentException) {
                            Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + noMediaPresentException);
                            Trace.trace(TRACE_MASKF, noMediaPresentException);
                            try {
                                this.mediaDevice.unlock();
                                this.mediaDevice = null;
                            }
                            catch (MediaDeviceLockException mediaDeviceLockException) {
                                Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                                Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                                this.mediaDevice = null;
                            }
                            if (this.panelTasklet != null) {
                                this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE);
                                this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT);
                                this.answer = this.displayMediaMessageBox(this.title, this.message);
                                if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                                throw new MediaServicesUtilException(noMediaPresentException, 11, this.isMessageBoxEnabled());
                            }
                            throw new MediaServicesUtilException(noMediaPresentException, 8, this.isMessageBoxEnabled());
                        }
                    }
                    isSuccessful = true;
                }
                catch (MediaDeviceLockException mediaDeviceLockException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                    Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                    this.mediaDevice = null;
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_LOCKED_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(mediaDeviceLockException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
                }
                catch (NoMediaPresentException noMediaPresentException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + noMediaPresentException);
                    Trace.trace(TRACE_MASKF, noMediaPresentException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_NO_MEDIA_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(noMediaPresentException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(noMediaPresentException, 8, this.isMessageBoxEnabled());
                }
                catch (MediaWriteProtectedException mediaWriteProtectedException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaWriteProtectedException);
                    Trace.trace(TRACE_MASKF, mediaWriteProtectedException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockExc) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockExc);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockExc);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_WRITE_PROTECTED_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_WRITE_PROTECTED_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(mediaWriteProtectedException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(mediaWriteProtectedException, 9, this.isMessageBoxEnabled());
                }
                catch (InvalidFileSystemException invalidFileSystemException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + invalidFileSystemException);
                    Trace.trace(TRACE_MASKF, invalidFileSystemException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INVALID_FILESYSTEM_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_INVALID_FILESYSTEM_ERROR_TEXT);
                        this.answer = this.displayMediaMessageBox(this.title, this.message);
                        if (!this.answer.equals(CommonMsgInterface.NO_BUTTON)) continue;
                        throw new MediaServicesUtilException(invalidFileSystemException, 11, this.isMessageBoxEnabled());
                    }
                    throw new MediaServicesUtilException(invalidFileSystemException, 10, this.isMessageBoxEnabled());
                }
                catch (MediaDeviceException mediaDeviceException) {
                    Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceException);
                    Trace.trace(TRACE_MASKF, mediaDeviceException);
                    try {
                        this.mediaDevice.unlock();
                        this.mediaDevice = null;
                    }
                    catch (MediaDeviceLockException mediaDeviceLockException) {
                        Trace.trace(TRACE_MASKF, "MediaServicesUtil.prepareMedia(): " + mediaDeviceLockException);
                        Trace.trace(TRACE_MASKF, mediaDeviceLockException);
                        this.mediaDevice = null;
                    }
                    if (this.panelTasklet != null) {
                        this.title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_DEVICE_ERROR_TITLE);
                        this.message = new MessageText(MEDIA_SERVICES_MESSAGES_FILENAME, "MDA.MEDIA.SERVICES.DEVICE.ERROR.TEXT");
                        this.displayMediaMessageBox(this.title, this.message);
                    }
                    throw new MediaServicesUtilException(mediaDeviceException, 3, this.isMessageBoxEnabled());
                }
            }
            Object var13_23 = null;
            this.destoryMediaServicesBusyDialog();
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            this.destoryMediaServicesBusyDialog();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<-  MediaServicesUtil.prepareMedia()");
        return this.mediaDevice;
    }

    public void releaseMedia() throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKT, "-> MediaServicesUtil.releaseMedia()");
        if (this.mediaDevice == null) {
            throw new MediaServicesUtilException("Cannot release a media device that is null", 2, this.isMessageBoxEnabled());
        }
        try {
            this.mediaDevice.unlock();
            this.mediaDevice = null;
        }
        catch (MediaDeviceLockException mediaDeviceLockException) {
            Trace.trace(TRACE_MASKF, "MediaServicesUtil.releaseMedia(): " + mediaDeviceLockException);
            Trace.trace(TRACE_MASKF, mediaDeviceLockException);
            this.mediaDevice = null;
            throw new MediaServicesUtilException(mediaDeviceLockException, 4, this.isMessageBoxEnabled());
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesUtil.releaseMedia()");
    }

    private LocalizableText displayMediaMessageBox(LocalizableText title, MessageText message) {
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.displayMediaMessageBox(title = " + title + ", " + "message = " + message + ")");
        LocalizableText answer = null;
        try {
            answer = this.panelTasklet.showMessageBox(true, title, message, null, null);
        }
        catch (TaskletException taskletException) {
            Trace.trace(TRACE_MASKF, "MediaServicesUtil.displayMediaMessageBox(): " + taskletException);
            Trace.trace(TRACE_MASKF, taskletException);
            new FrameworkLog(LOGINFO, 629, taskletException).log();
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.displayMediaMessageBox()");
        return answer;
    }

    private void showMediaServicesBusyDialog() {
        MediaServicesBusyInterface busyInterface;
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.showMediaServicesBusyDialog()");
        if (this.panelTasklet != null && this.panelTasklet instanceof MediaServicesBusyInterface && (busyInterface = (MediaServicesBusyInterface)((Object)this.panelTasklet)).isBusyDesired()) {
            this.busyPanelTasklet = busyInterface.getPanelTasklet();
            if (this.busyPanelTasklet != null) {
                LocalizableText message = busyInterface.getBusyMessage();
                if (message == null) {
                    message = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_BUSY_TEXT);
                }
                try {
                    LocalizableText title = new LocalizableText(MEDIA_SERVICES_MESSAGES_FILENAME, MEDIA_SERVICES_BUSY_TITLE);
                    this.busyPanelTasklet.showBusyDialog(title, message);
                    this.busyDisplayed = true;
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.showMediaServicesBusyDialog()");
    }

    private void destoryMediaServicesBusyDialog() {
        Trace.trace(TRACE_MASKF, "-> MediaServicesUtil.destroyMediaServicesBusyDialog()");
        if (this.busyPanelTasklet != null && this.busyDisplayed) {
            try {
                this.busyPanelTasklet.destroyBusyDialog();
                this.busyDisplayed = false;
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKF, "<- MediaServicesUtil.destroyMediaServicesBusyDialog()");
    }
}

